/*
 * Decompiled with CFR 0.152.
 */
package BakuPackage;

import BakuPackage.Boule;
import BakuPackage.Partie;
import BakuPackage.TableauDeBoule;

public class CoupleBoule {
    private Boule b1;
    private Boule b2;
    private TableauDeBoule tableau;
    private static final int DEPARTX1 = 5 * Partie.IMAGEDIM / 2;
    private static final int DEPARTX2 = 7 * Partie.IMAGEDIM / 2;
    private static final int DEPARTY = 6;

    public CoupleBoule(TableauDeBoule tableau, int maxi) {
        this.tableau = tableau;
        this.b1 = new Boule(DEPARTX1 + tableau.getABS0(), 6 + Partie.IMAGEDIM / 2, tableau, maxi);
        this.b2 = new Boule(DEPARTX2 + tableau.getABS0(), 6 + Partie.IMAGEDIM / 2, tableau, maxi);
    }

    public CoupleBoule(TableauDeBoule tableau, int maxi, String s1, String s2) {
        this.tableau = tableau;
        this.b1 = new Boule(DEPARTX1 + tableau.getABS0(), 6 + Partie.IMAGEDIM / 2, tableau, s1);
        this.b2 = new Boule(DEPARTX2 + tableau.getABS0(), 6 + Partie.IMAGEDIM / 2, tableau, s2);
    }

    public Boule getBoule1() {
        return this.b1;
    }

    public Boule getBoule2() {
        return this.b2;
    }

    public void Show() {
        System.out.println("Affichage : \nBoules 1 - En String : " + this.b1.getType() + " - En Entier : " + this.b1.getType(0) + "\nBoules 2 - En String : " + this.b2.getType() + " - En Entier : " + this.b2.getType(0));
    }

    public boolean peutDescendre(int vitesse) {
        return this.b1.peutDescendre(vitesse) && this.b2.peutDescendre(vitesse);
    }

    public void descend(int vitesse) {
        this.b1.descend(vitesse);
        this.b2.descend(vitesse);
    }

    public boolean peutTranslater(int direction) {
        Boule bouleDroite;
        if (direction == 0) {
            return false;
        }
        if (this.b1.getLigne() == 11 || this.b2.getLigne() == 11) {
            if (direction == 1) {
                return this.b1.getColonne() != 5 && this.b2.getColonne() != 5;
            }
            return this.b1.getColonne() != 0 && this.b2.getColonne() != 0;
        }
        if (this.b1.getX() == this.b2.getX()) {
            if (direction == 1) {
                if (this.b1.getColonne() == 5) {
                    return false;
                }
                if (this.tableau.getBoule(this.b1.getColonne() + 1, this.b1.getLigne()) != null) {
                    return false;
                }
                if (this.b2.getColonne() == 5) {
                    return false;
                }
                return this.tableau.getBoule(this.b2.getColonne() + 1, this.b2.getLigne()) == null;
            }
            if (this.b1.getColonne() == 0) {
                return false;
            }
            if (this.tableau.getBoule(this.b1.getColonne() - 1, this.b1.getLigne()) != null) {
                return false;
            }
            if (this.b2.getColonne() == 0) {
                return false;
            }
            return this.tableau.getBoule(this.b2.getColonne() - 1, this.b2.getLigne()) == null;
        }
        Boule bouleGauche = this.b1.getX() >= this.b2.getX() ? this.b2 : this.b1;
        Boule boule = bouleDroite = this.b1.getX() >= this.b2.getX() ? this.b1 : this.b2;
        if (direction == 1) {
            if (bouleDroite.getColonne() == 5) {
                return false;
            }
            return this.tableau.getBoule(bouleDroite.getColonne() + 1, bouleDroite.getLigne()) == null;
        }
        if (bouleGauche.getColonne() == 0) {
            return false;
        }
        return this.tableau.getBoule(bouleGauche.getColonne() - 1, bouleDroite.getLigne()) == null;
    }

    public void translate(int sens) {
        this.b1.setPosition(this.b1.getX() + sens * Partie.IMAGEDIM, this.b1.getY());
        this.b2.setPosition(this.b2.getX() + sens * Partie.IMAGEDIM, this.b2.getY());
    }

    public boolean peutTourner(int rotation) {
        if (rotation == 0) {
            return false;
        }
        if (this.b1.getLigne() >= 11 || this.b2.getLigne() >= 11) {
            return true;
        }
        if (this.b1.getX() != this.b2.getX()) {
            Boule bouleDroite;
            Boule bouleGauche = this.b1.getX() >= this.b2.getX() ? this.b2 : this.b1;
            Boule boule = bouleDroite = this.b1.getX() >= this.b2.getX() ? this.b1 : this.b2;
            if (bouleGauche.equals(this.b1)) {
                if (rotation == 1) {
                    if (this.b2.getLigne() == 0) {
                        return false;
                    }
                    return this.tableau.getBoule(this.b1.getColonne(), this.b2.getLigne() - 1) == null;
                }
                return this.b1.getLigne() != 10;
            }
            if (rotation == -1) {
                if (this.b2.getLigne() == 0) {
                    return false;
                }
                return this.tableau.getBoule(this.b1.getColonne(), this.b2.getLigne() - 1) == null;
            }
            return this.b1.getLigne() != 10;
        }
        return true;
    }

    public boolean bloqueGauche(int rotation) {
        if (rotation == 0) {
            return false;
        }
        if (this.b1.getX() == this.b2.getX()) {
            Boule bouleBas;
            Boule bouleHaut = this.b1.getY() >= this.b2.getY() ? this.b2 : this.b1;
            Boule boule = bouleBas = this.b1.getY() >= this.b2.getY() ? this.b1 : this.b2;
            if (bouleBas.equals(this.b1)) {
                if (rotation == -1) {
                    if (this.b2.getColonne() == 0) {
                        return true;
                    }
                    return this.tableau.getBoule(this.b2.getColonne() - 1, this.b1.getLigne()) != null;
                }
                return false;
            }
            if (rotation == 1) {
                if (this.b2.getColonne() == 0) {
                    return true;
                }
                return this.tableau.getBoule(this.b2.getColonne() - 1, this.b1.getLigne()) != null;
            }
            return false;
        }
        return false;
    }

    public boolean bloqueDroite(int rotation) {
        if (rotation == 0) {
            return false;
        }
        if (this.b1.getX() == this.b2.getX()) {
            Boule bouleBas;
            Boule bouleHaut = this.b1.getY() >= this.b2.getY() ? this.b2 : this.b1;
            Boule boule = bouleBas = this.b1.getY() >= this.b2.getY() ? this.b1 : this.b2;
            if (bouleBas.equals(this.b1)) {
                if (rotation == 1) {
                    if (this.b2.getColonne() == 5) {
                        return true;
                    }
                    return this.tableau.getBoule(this.b2.getColonne() + 1, this.b1.getLigne()) != null;
                }
                return false;
            }
            if (rotation == -1) {
                if (this.b2.getColonne() == 5) {
                    return true;
                }
                return this.tableau.getBoule(this.b2.getColonne() + 1, this.b1.getLigne()) != null;
            }
            return false;
        }
        return false;
    }

    public boolean bloqueGaucheDroite(int rotation) {
        if (rotation == 0) {
            return false;
        }
        if (this.b1.getX() == this.b2.getX()) {
            Boule bouleBas;
            Boule bouleHaut = this.b1.getY() >= this.b2.getY() ? this.b2 : this.b1;
            Boule boule = bouleBas = this.b1.getY() >= this.b2.getY() ? this.b1 : this.b2;
            if (bouleBas.getColonne() == 5) {
                return this.tableau.getBoule(bouleBas.getColonne() - 1, bouleBas.getLigne()) != null && this.tableau.getBoule(bouleHaut.getColonne() - 1, bouleHaut.getLigne()) != null;
            }
            if (bouleBas.getColonne() == 0) {
                return this.tableau.getBoule(bouleBas.getColonne() + 1, bouleBas.getLigne()) != null && this.tableau.getBoule(bouleHaut.getColonne() + 1, bouleHaut.getLigne()) != null;
            }
            return this.tableau.getBoule(bouleBas.getColonne() - 1, bouleBas.getLigne()) != null && this.tableau.getBoule(bouleHaut.getColonne() - 1, bouleHaut.getLigne()) != null && this.tableau.getBoule(bouleBas.getColonne() + 1, bouleBas.getLigne()) != null && this.tableau.getBoule(bouleHaut.getColonne() + 1, bouleHaut.getLigne()) != null;
        }
        return false;
    }

    public void tourne(int sens) {
        if (this.b1.getX() != this.b2.getX()) {
            Boule bouleDroite;
            Boule bouleGauche = this.b1.getX() >= this.b2.getX() ? this.b2 : this.b1;
            Boule boule = bouleDroite = this.b1.getX() >= this.b2.getX() ? this.b1 : this.b2;
            if (bouleGauche.equals(this.b1)) {
                this.b2.setPosition(this.b1.getX(), this.b1.getY() + sens * Partie.IMAGEDIM);
            } else {
                this.b2.setPosition(this.b1.getX(), this.b1.getY() - sens * Partie.IMAGEDIM);
            }
        } else {
            Boule bouleBas;
            Boule bouleHaut = this.b1.getY() >= this.b2.getY() ? this.b2 : this.b1;
            Boule boule = bouleBas = this.b1.getY() >= this.b2.getY() ? this.b1 : this.b2;
            if (bouleBas.equals(this.b1)) {
                if (this.bloqueGaucheDroite(sens)) {
                    this.b2.setPosition(this.b1.getX(), this.b1.getY());
                    this.b1.setPosition(this.b1.getX(), this.b1.getY() - Partie.IMAGEDIM);
                } else if (this.bloqueGauche(sens) || this.bloqueDroite(sens)) {
                    this.b2.setPosition(this.b1.getX(), this.b1.getY());
                    this.b1.setPosition(this.b1.getX() - sens * Partie.IMAGEDIM, this.b1.getY());
                } else {
                    this.b2.setPosition(this.b1.getX() + sens * Partie.IMAGEDIM, this.b1.getY());
                }
            } else if (this.bloqueGaucheDroite(sens)) {
                this.b1.setPosition(this.b2.getX(), this.b2.getY());
                this.b2.setPosition(this.b2.getX(), this.b2.getY() - Partie.IMAGEDIM);
            } else if (this.bloqueGauche(sens) || this.bloqueDroite(sens)) {
                this.b1.setPosition(this.b2.getX(), this.b2.getY());
                this.b2.setPosition(this.b2.getX() + sens * Partie.IMAGEDIM, this.b2.getY());
            } else {
                this.b2.setPosition(this.b1.getX() - sens * Partie.IMAGEDIM, this.b1.getY());
            }
        }
    }

    public int fixe(boolean b) {
        int t1 = 0;
        int t2 = 0;
        t1 = this.b1.fixe(b);
        t2 = this.b2.fixe(b);
        return t1 + t2;
    }
}

