/*
 * Decompiled with CFR 0.152.
 */
package BakuPackage;

import BakuPackage.FenetreDeJeu;
import BakuPackage.Partie;
import BakuPackage.TableauDeBoule;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class Boule {
    private String type = "0";
    private int x;
    private int y;
    private TableauDeBoule tab;

    public Boule(int x, int y, TableauDeBoule tableau, int maxi) {
        Double d1 = new Double(Math.floor((double)(maxi * 2) * Math.random()));
        this.type = new Integer(d1.intValue()).toString();
        if (Integer.parseInt(this.type) >= maxi) {
            if (Math.random() < 0.6) {
                char[] tabChar = new char[]{'A'};
                tabChar[0] = (char)(65 + Integer.parseInt(this.type) - maxi);
                this.type = new String(tabChar);
            } else {
                this.type = new Integer(Integer.parseInt(this.type) - maxi).toString();
            }
        }
        this.x = x;
        this.y = y;
        this.tab = tableau;
    }

    public Boule(int x, int y, TableauDeBoule tableau) {
        this.x = x;
        this.y = y;
        this.tab = tableau;
        this.type = new String("Special");
    }

    public Boule(int x, int y, TableauDeBoule tableau, String string) {
        this.x = x;
        this.y = y;
        this.tab = tableau;
        this.type = new String(string);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getType() {
        return this.type;
    }

    public int getType(int maxi) {
        if (this.type.equals("Special") || this.type.equals("Mange")) {
            return -1;
        }
        try {
            return Integer.parseInt(this.type);
        }
        catch (Exception e) {
            char tabChar = this.type.charAt(0);
            tabChar = (char)(tabChar - 65);
            return tabChar;
        }
    }

    public void setPosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public void setType(String s) {
        this.type = s;
    }

    public int getColonne() {
        return this.tab.getColonne(this.x);
    }

    public int getLigne() {
        return this.tab.getLigne(this.y);
    }

    public void affiche(Graphics g) {
        if (this.type.equals("Special") || this.type.equals("Mange")) {
            if (this.type.equals("Special")) {
                g.drawImage(FenetreDeJeu.IMAGESPECIAL.getImage(), this.x - Partie.IMAGEDIM / 2, this.y - (Partie.IMAGEDIM + 7) / 2, null);
            }
        } else if (this.isAliment()) {
            g.drawImage(FenetreDeJeu.IMAGEALIMENTS[this.getType(0)].getImage(), this.x - Partie.IMAGEDIM / 2, this.y - (Partie.IMAGEDIM + 7) / 2, null);
        } else {
            g.drawImage(FenetreDeJeu.IMAGEANIMAUX[this.getType(0)].getImage(), this.x - Partie.IMAGEDIM / 2, this.y - (Partie.IMAGEDIM + 7) / 2, null);
        }
    }

    public boolean peutDescendre(int distance) {
        int prochaine_ligne = this.tab.getLigne(this.y + Partie.IMAGEDIM / 2 + distance);
        if (prochaine_ligne < 0) {
            return false;
        }
        return !this.tab.presenceBoule(this.getColonne(), prochaine_ligne);
    }

    public void descend(int distance) {
        this.y += distance;
    }

    public int fixe(boolean b) {
        int t = this.tab.setCase(this.getColonne(), this.getLigne(), this);
        if (b) {
            try {
                new Thread(){

                    public void run() {
                        String cheminSon = ".//BakuPackage//element//sound//tombe.wav";
                        try {
                            File f = new File(cheminSon);
                            URL url = f.toURL();
                            AudioClip son1 = Applet.newAudioClip(url);
                            son1.play();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public boolean isAnimal() {
        if (this.type.equals("Special") || this.type.equals("Mange")) {
            return false;
        }
        return this.getType().matches("[A-Z]");
    }

    public boolean isAliment() {
        if (this.type.equals("Special") || this.type.equals("Mange")) {
            return false;
        }
        return this.getType().matches("[0-9]");
    }

    public Vector getAdjacentes(Vector listes) {
        listes.addElement(this);
        this.setPosition(this.getX() + this.tab.getABS0(), this.getY() + this.tab.getORD0());
        int colonne = this.getColonne();
        int ligne = this.getLigne();
        this.setPosition(this.getX() - this.tab.getABS0(), this.getY() - this.tab.getORD0());
        for (int i = -1; i <= 1; i += 2) {
            Boule bouleAdjacente;
            if (this.tab.presenceBoule(colonne + i, ligne) && !listes.contains(bouleAdjacente = this.tab.getBoule(colonne + i, ligne)) && bouleAdjacente.getType(0) == this.getType(0)) {
                if (bouleAdjacente.isAliment()) {
                    bouleAdjacente.getAdjacentes(listes);
                } else if (this.isAliment()) {
                    listes.addElement(bouleAdjacente);
                }
            }
            if (!this.tab.presenceBoule(colonne, ligne + i) || listes.contains(bouleAdjacente = this.tab.getBoule(colonne, ligne + i)) || bouleAdjacente.getType(0) != this.getType(0)) continue;
            if (bouleAdjacente.isAliment()) {
                bouleAdjacente.getAdjacentes(listes);
                continue;
            }
            if (!this.isAliment()) continue;
            listes.addElement(bouleAdjacente);
        }
        return listes;
    }

    public Boule chercheAliment(String cherche) {
        this.setPosition(this.getX() + this.tab.getABS0(), this.getY() + this.tab.getORD0());
        int colonne = this.getColonne();
        int ligne = this.getLigne();
        this.setPosition(this.getX() - this.tab.getABS0(), this.getY() - this.tab.getORD0());
        for (int i = -1; i <= 1; i += 2) {
            Boule bouleAdjacente;
            if (this.tab.presenceBoule(colonne + i, ligne) && (bouleAdjacente = this.tab.getBoule(colonne + i, ligne)).getType().equals(cherche)) {
                return bouleAdjacente;
            }
            if (!this.tab.presenceBoule(colonne, ligne + i) || !(bouleAdjacente = this.tab.getBoule(colonne, ligne + i)).getType().equals(cherche)) continue;
            return bouleAdjacente;
        }
        return null;
    }

    public char getTypeEstMangePar() {
        char[] tabChar = new char[]{'A'};
        tabChar[0] = (char)(65 + Integer.parseInt(this.type));
        return tabChar[0];
    }
}

