/*
 * Decompiled with CFR 0.152.
 */
package BakuPackage;

import BakuPackage.CoupleBoule;
import BakuPackage.FenetreDeJeu;
import BakuPackage.Partie;
import BakuPackage.TableauDeBoule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.MaskFormatter;

public class DemoComputer
extends Partie {
    private Image backGround = null;
    public Boolean doRefresh;
    public Boolean perdu;
    public Boolean gagne;
    private TableauDeBoule tableau = null;
    private CoupleBoule coupleBoule;
    private CoupleBoule next;
    private int rotation;
    private int translation;
    private int vitesseDansPartie;
    private int vitesseInitialeDesOptions;
    private int scoreTotal;
    private int combo;
    private int compteRebours;
    private int clignotageScore;
    private int hauteurInitiale;
    private String dureePartie;
    private long diff = 0L;
    private long DUREE_MAX_DEMO = 3000L;
    private boolean interruptionUtilisateur = false;

    public DemoComputer(Image backGround, FenetreDeJeu FdJ, int hauteurInit) {
        this.backGround = backGround;
        fdj = FdJ;
        this.setOpaque(false);
        this.doRefresh = true;
        this.setVisible(true);
        this.perdu = false;
        this.gagne = false;
        this.vitesseDansPartie = 0;
        this.vitesseInitialeDesOptions = 0;
        this.scoreTotal = 0;
        this.combo = 0;
        this.compteRebours = 3;
        this.clignotageScore = 0;
        this.hauteurInitiale = hauteurInit;
        this.dureePartie = "";
        this.diff = 0L;
        this.interruptionUtilisateur = false;
    }

    public void setPerdu(Boolean bool) {
        this.perdu = bool;
    }

    public void setGagne(Boolean bool) {
        this.gagne = bool;
    }

    public FenetreDeJeu getFenetreDeJeu() {
        return fdj;
    }

    public void play() {
        Date debut = new Date();
        Date fin = null;
        do {
            this.repaint();
            fin = new Date();
            this.diff = fin.getTime() - debut.getTime();
        } while (!this.interruptionUtilisateur && this.diff < this.DUREE_MAX_DEMO);
        this.detruit();
    }

    public synchronized boolean getPerdu() {
        return this.perdu;
    }

    public synchronized boolean getGagne() {
        return this.gagne;
    }

    public synchronized int getRotation() {
        return this.rotation;
    }

    public synchronized void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public synchronized int getTranslation() {
        return this.translation;
    }

    public synchronized void setTranslation(int trans) {
        this.translation = trans;
    }

    public synchronized void setVitesseDansPartie() {
        this.vitesseDansPartie = 4;
    }

    public synchronized void setInterruptionUtilisateur(boolean interruptionUtilisateur) {
        this.interruptionUtilisateur = interruptionUtilisateur;
    }

    public void refresh() {
        while (this.doRefresh.booleanValue()) {
            this.Actualise();
        }
    }

    public void paint(Graphics g) {
        if (this.backGround != null) {
            g.drawImage(this.backGround, 0, 0, this.getSize().width, this.getSize().height, this);
        }
        super.paint(g);
        g.setColor(Color.blue);
        if (this.tableau != null) {
            g.translate(this.tableau.getABS0(), this.tableau.getORD0());
            this.tableau.affiche(g);
            g.translate(-this.tableau.getABS0(), -this.tableau.getORD0());
            this.afficheScore(g);
        }
        if (this.compteRebours > -1) {
            g.drawImage(FenetreDeJeu.IMAGEREBOURS[this.compteRebours].getImage(), 275, 185, null);
        }
        if (this.next != null) {
            this.afficheNext(g);
        }
        if (this.coupleBoule != null) {
            this.afficheCoupleDeBoules(g);
        }
        g.setColor(Color.black);
        if (this.getPerdu()) {
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(0, 0, 600, 420);
            g.setFont(FenetreDeJeu.policeEcriture50);
            g.setColor(Color.white);
            g.drawString("GAME OVER", 150, 200);
        }
        if (this.getGagne()) {
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(0, 0, 600, 420);
            g.setFont(FenetreDeJeu.policeEcriture50);
            g.setColor(Color.white);
            g.drawString("YOU WIN !", 150, 200);
        }
        g.setColor(new Color(0, 0, 0, 150));
        g.fillRect(0, 0, 600, 420);
        g.setFont(FenetreDeJeu.policeEcriture50);
        g.setColor(Color.white);
        g.drawString("" + this.diff, 300, 200);
    }

    public void afficheCoupleDeBoules(Graphics g) {
        this.coupleBoule.getBoule1().affiche(g);
        this.coupleBoule.getBoule2().affiche(g);
    }

    public void afficheNext(Graphics g) {
        this.next.getBoule1().affiche(g);
        this.next.getBoule2().affiche(g);
    }

    public void afficheScore(Graphics g) {
        String score = new String(new Integer(this.scoreTotal).toString());
        int j = 0;
        if (this.clignotageScore % 2 == 0 || this.getPerdu()) {
            for (int i = score.length() - 1; i > -1; --i) {
                String _tmp = score;
                int chiffre = Integer.parseInt(String.valueOf(score.charAt(i)));
                FenetreDeJeu _tmp1 = fdj;
                g.drawImage(FenetreDeJeu.IMAGESCOREP1[chiffre].getImage(), 542 - 16 * j, 179, null);
                ++j;
            }
        }
        if (this.clignotageScore > 0) {
            --this.clignotageScore;
        }
    }

    public void Actualise() {
        try {
            Thread.sleep(15L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void perdu() {
        final JDialog saveScore = new JDialog();
        JPanel mainPanel = new JPanel();
        JLabel copyrightTextArea = new JLabel();
        JButton ouiButton = new JButton();
        JButton nonButton = new JButton();
        saveScore.getContentPane().setLayout(new GridBagLayout());
        saveScore.setTitle("Congratulation, you've made " + this.scoreTotal);
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(new EmptyBorder(new Insets(11, 11, 12, 12)));
        copyrightTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        copyrightTextArea.setText("<html>Save your score on the Internet ?</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        mainPanel.add((Component)copyrightTextArea, gridBagConstraints);
        ouiButton.setMnemonic('Y');
        ouiButton.setText("Yes");
        ouiButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                saveScore.setVisible(false);
                DemoComputer.this.nameAndScore();
                saveScore.dispose();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        mainPanel.add((Component)ouiButton, gridBagConstraints);
        nonButton.setMnemonic('N');
        nonButton.setText("No");
        nonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                saveScore.setVisible(false);
                saveScore.dispose();
                DemoComputer.this.detruit();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        mainPanel.add((Component)nonButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        saveScore.getContentPane().add((Component)mainPanel, gridBagConstraints);
        saveScore.setSize(new Dimension(250, 100));
        Rectangle parentBounds = fdj.getBounds();
        Dimension size = saveScore.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        saveScore.setLocation(new Point(x, y));
        saveScore.setResizable(false);
        saveScore.setVisible(true);
    }

    public void perduSansScore() {
        final JDialog saveScore = new JDialog();
        JPanel mainPanel = new JPanel();
        JLabel copyrightTextArea = new JLabel();
        JButton nonButton = new JButton();
        saveScore.getContentPane().setLayout(new GridBagLayout());
        saveScore.setTitle("You've made " + this.scoreTotal);
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(new EmptyBorder(new Insets(11, 11, 12, 12)));
        copyrightTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        copyrightTextArea.setText("<html>Sorry, you lose...</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        mainPanel.add((Component)copyrightTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        nonButton.setMnemonic('B');
        nonButton.setText("Back to menu");
        nonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                saveScore.setVisible(false);
                saveScore.dispose();
                DemoComputer.this.detruit();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        mainPanel.add((Component)nonButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        saveScore.getContentPane().add((Component)mainPanel, gridBagConstraints);
        saveScore.setSize(new Dimension(250, 100));
        Rectangle parentBounds = fdj.getBounds();
        Dimension size = saveScore.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        saveScore.setLocation(new Point(x, y));
        saveScore.setResizable(false);
        saveScore.setVisible(true);
    }

    public void gagne() {
        final JDialog saveScore = new JDialog();
        JPanel mainPanel = new JPanel();
        JLabel copyrightTextArea = new JLabel();
        JButton nonButton = new JButton();
        saveScore.getContentPane().setLayout(new GridBagLayout());
        saveScore.setTitle("Congratulations, you've made " + this.scoreTotal);
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(new EmptyBorder(new Insets(11, 11, 12, 12)));
        copyrightTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        copyrightTextArea.setText("<html>Congratulations !<br>You made it in " + this.dureePartie + ".<br>Can you do it faster ?</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        mainPanel.add((Component)copyrightTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        nonButton.setMnemonic('B');
        nonButton.setText("Back to menu");
        nonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                saveScore.setVisible(false);
                saveScore.dispose();
                DemoComputer.this.detruit();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        mainPanel.add((Component)nonButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        saveScore.getContentPane().add((Component)mainPanel, gridBagConstraints);
        saveScore.setSize(new Dimension(250, 150));
        Rectangle parentBounds = fdj.getBounds();
        Dimension size = saveScore.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        saveScore.setLocation(new Point(x, y));
        saveScore.setResizable(false);
        saveScore.setVisible(true);
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public void nameAndScore() {
        final JDialog namePlayer = new JDialog();
        JPanel mainPanel = new JPanel();
        JLabel copyrightTextArea = new JLabel();
        final JFormattedTextField yourName = new JFormattedTextField(this.createFormatter("**********"));
        JButton okButton = new JButton();
        namePlayer.getContentPane().setLayout(new GridBagLayout());
        namePlayer.setTitle("Please enter your name");
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(new EmptyBorder(new Insets(11, 11, 12, 12)));
        copyrightTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        copyrightTextArea.setText("<html>What's your name ?</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        mainPanel.add((Component)copyrightTextArea, gridBagConstraints);
        yourName.setText("Your Name");
        yourName.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        mainPanel.add((Component)yourName, gridBagConstraints);
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                namePlayer.setVisible(false);
                DemoComputer.this.highScore(yourName.getText());
                namePlayer.dispose();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        mainPanel.add((Component)okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        namePlayer.getContentPane().add((Component)mainPanel, gridBagConstraints);
        namePlayer.setSize(new Dimension(250, 100));
        Rectangle parentBounds = fdj.getBounds();
        Dimension size = namePlayer.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        namePlayer.setLocation(new Point(x, y));
        namePlayer.setResizable(false);
        namePlayer.setVisible(true);
    }

    public void highScore(String nomJoueur) {
        String response = null;
        final JDialog boite = new JDialog();
        try {
            int inChar;
            URL u = new URL("http://www.jeanmichelfahys.net/bakubaku//score.php");
            HttpURLConnection cnx = (HttpURLConnection)u.openConnection();
            cnx.setRequestMethod("POST");
            cnx.setDoInput(true);
            cnx.setDoOutput(true);
            cnx.connect();
            String datipost = URLEncoder.encode("nom", "UTF-8") + "=" + URLEncoder.encode(nomJoueur, "UTF-8") + "&" + URLEncoder.encode("score", "UTF-8") + "=" + URLEncoder.encode(new Integer(this.scoreTotal).toString(), "UTF-8");
            OutputStreamWriter out = new OutputStreamWriter(cnx.getOutputStream());
            out.write(datipost);
            out.flush();
            out.close();
            InputStream in = null;
            StringBuffer inBuffer = new StringBuffer();
            in = cnx.getInputStream();
            while ((inChar = in.read()) != -1) {
                inBuffer.append((char)inChar);
            }
            response = inBuffer.toString();
            in.close();
            cnx.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            response = "Connexion impossible.";
        }
        JPanel mainPanel = new JPanel();
        JLabel copyrightTextArea = new JLabel();
        JButton closeButton = new JButton();
        boite.getContentPane().setLayout(new GridBagLayout());
        boite.setDefaultCloseOperation(2);
        boite.setTitle("Hi-scores");
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(new EmptyBorder(new Insets(11, 11, 12, 12)));
        copyrightTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        copyrightTextArea.setText("<html>" + response + "</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(copyrightTextArea);
        scrollPane.setPreferredSize(new Dimension(600, 195));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        mainPanel.add((Component)scrollPane, gridBagConstraints);
        closeButton.setMnemonic('C');
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boite.setVisible(false);
                boite.dispose();
                DemoComputer.this.detruit();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        mainPanel.add((Component)closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        boite.getContentPane().add((Component)mainPanel, gridBagConstraints);
        Rectangle parentBounds = fdj.getBounds();
        boite.setSize(new Dimension(250, 375));
        Dimension size = boite.getSize();
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        boite.setLocation(new Point(x, y));
        boite.setResizable(false);
        boite.setVisible(true);
    }

    public void affiche() {
        this.setVisible(true);
        this.doRefresh = true;
    }

    public void detruit() {
        this.perdu = false;
        this.gagne = false;
        this.next = null;
        this.coupleBoule = null;
        this.vitesseDansPartie = 0;
        this.vitesseInitialeDesOptions = 0;
        this.scoreTotal = 0;
        this.combo = 0;
        this.compteRebours = 3;
        this.clignotageScore = 0;
        this.diff = 0L;
        this.interruptionUtilisateur = false;
        fdj.remove(this);
        this.doRefresh = true;
        this.tableau = null;
        fdj.relanceMenu();
        System.err.println("FIN DEMO");
        FenetreDeJeu.setDemoEnExecution(false);
    }

    public String calculeAfficheDuree(Date debut, Date fin) {
        long diff = fin.getTime() - debut.getTime();
        String millisecondes = Long.toString(diff % 1000L);
        diff = (long)Math.floor(diff / 1000L);
        String secondes = Long.toString(diff % 60L);
        diff = (long)Math.floor(diff / 60L);
        String minutes = Long.toString(diff % 60L);
        diff = (long)Math.floor(diff / 60L);
        String heures = Long.toString(diff % 60L);
        diff = (long)Math.floor(diff / 60L);
        if (millisecondes.length() == 1) {
            millisecondes = "0" + millisecondes;
        }
        if (millisecondes.length() == 2) {
            millisecondes = "0" + millisecondes;
        }
        if (secondes.length() == 1) {
            secondes = "0" + secondes;
        }
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        StringBuffer retour = new StringBuffer();
        if (!"0".equals(heures)) {
            retour.append(heures);
            retour.append("H ");
        }
        if (!"00".equals(minutes) || !"0".equals(heures)) {
            retour.append(minutes);
            retour.append("min ");
        }
        if (!("00".equals(secondes) && "00".equals(minutes) && "0".equals(heures))) {
            retour.append(secondes);
            retour.append("s ");
        }
        retour.append(millisecondes);
        retour.append("ms");
        return retour.toString();
    }
}

