/*
 * Decompiled with CFR 0.152.
 */
package BakuPackage;

import BakuPackage.Boule;
import BakuPackage.Partie;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics;
import java.io.File;
import java.net.URL;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableauDeBoule {
    public static final int LARGEUR = 6;
    public static final int HAUTEUR = 11;
    public int ABS0;
    public int ORD0;
    private Partie partie;
    private Boule[][] tableauBoules = new Boule[6][11];
    private Vector boulesDansLeVide = new Vector();
    private Vector kiMangeKoi;
    private Vector animauxKiMangent = new Vector();
    private Vector boulesAVirer = new Vector();
    private int scoreSurMangeage;
    private int clignotementBoules;
    private int level;
    private int vitesse;
    private int nbSet = 0;

    public TableauDeBoule(int abs, int ord) {
        this.kiMangeKoi = new Vector();
        this.level = Partie.fdj.getNbCoupleAlimentsAnimaux();
        this.vitesse = Partie.fdj.getVitesseDuJeu();
        this.ABS0 = abs;
        this.ORD0 = ord;
        this.clignotementBoules = 0;
    }

    public int getABS0() {
        return this.ABS0;
    }

    public int getORD0() {
        return this.ORD0;
    }

    public void init(int hauteurInitiale) {
        int j;
        int i;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 11; ++j) {
                this.tableauBoules[i][j] = null;
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < hauteurInitiale; ++j) {
            }
        }
        if (hauteurInitiale != 1) {
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < hauteurInitiale + 1; ++j) {
                    int x = Partie.IMAGEDIM * i + Partie.IMAGEDIM / 2;
                    int y = Partie.IMAGEDIM * (11 - j) + Partie.IMAGEDIM / 2;
                    boolean bouleMangeVoisin = false;
                    Vector<Boule> listeBoulesAdjacentes = this.getBoulesAdjacentesStrictes(i, j);
                    Boule b = null;
                    do {
                        b = new Boule(x, y, this, this.level);
                        System.out.print("Boule : " + b.getType() + " | ");
                        for (int k = 0; k < listeBoulesAdjacentes.size(); ++k) {
                            System.out.print(listeBoulesAdjacentes.get(k).getType() + " ");
                        }
                        System.out.println();
                    } while (bouleMangeVoisin = this.isOppositeTypeOfBouleInVector(b, listeBoulesAdjacentes));
                    this.tableauBoules[i][j] = b;
                }
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    public int getVitesse() {
        return this.vitesse;
    }

    public void affiche(Graphics g) {
        int i;
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 11; ++j) {
                Boule temp = this.getBoule(i, j);
                if (temp == null || this.boulesAVirer.contains(temp) && this.clignotementBoules % 2 == 1) continue;
                this.getBoule(i, j).affiche(g);
            }
        }
        for (i = 0; i < this.getNombreDeBoulesDansLeVide(); ++i) {
            Boule maBoule = this.getBouleDansLeVide(i);
            maBoule.affiche(g);
        }
    }

    public int getNombreDeBoulesDansLeVide() {
        return this.boulesDansLeVide.size();
    }

    public Boule getBouleDansLeVide(int place) {
        return (Boule)this.boulesDansLeVide.elementAt(place);
    }

    public int getCouleur(int x, int y) {
        return this.tableauBoules[x][y].getType(this.level);
    }

    public Boule getBoule(int x, int y) {
        if (!this.presenceBoule(x, y)) {
            return null;
        }
        return this.tableauBoules[x][y];
    }

    public int setCase(int x, int y, Boule boule) {
        if (y == 11) {
            return -1;
        }
        boule.setPosition(Partie.IMAGEDIM * boule.getColonne() + Partie.IMAGEDIM / 2, Partie.IMAGEDIM * (11 - boule.getLigne()) + Partie.IMAGEDIM / 2);
        this.tableauBoules[x][y] = boule;
        return 0;
    }

    public int getColonne(int x) {
        return (x - this.getABS0()) / Partie.IMAGEDIM;
    }

    public int getLigne(int y) {
        return 11 - (y - this.getORD0()) / Partie.IMAGEDIM;
    }

    public boolean presenceBoule(int colonne, int ligne) {
        if (ligne > 10 || ligne < 0 || colonne > 5 || colonne < 0) {
            return false;
        }
        return this.tableauBoules[colonne][ligne] != null;
    }

    public void calculeLesBoulesDansLeVide() {
        this.boulesDansLeVide.removeAllElements();
        for (int i = 0; i < 6; ++i) {
            boolean enLAir = false;
            for (int j = 0; j < 11; ++j) {
                if (enLAir) {
                    if (!this.presenceBoule(i, j)) continue;
                    this.boulesDansLeVide.addElement(this.tableauBoules[i][j]);
                    this.tableauBoules[i][j] = null;
                    continue;
                }
                if (this.presenceBoule(i, j)) continue;
                enLAir = true;
            }
        }
    }

    public void descendLesBoulesDansLeVide(boolean b) {
        int i = 0;
        while (i < this.boulesDansLeVide.size()) {
            Boule maBoule = (Boule)this.boulesDansLeVide.elementAt(i);
            maBoule.setPosition(maBoule.getX() + this.ABS0, maBoule.getY() + this.ORD0);
            if (maBoule.peutDescendre(4)) {
                maBoule.setPosition(maBoule.getX() - this.ABS0, maBoule.getY() - this.ORD0);
                maBoule.descend(4);
                ++i;
                continue;
            }
            maBoule.fixe(b);
            this.boulesDansLeVide.removeElementAt(i);
        }
    }

    public boolean comporteDesBoulesDansLeVide() {
        return this.boulesDansLeVide.size() != 0;
    }

    public boolean comporteDesAliments() {
        return this.kiMangeKoi.size() != 0;
    }

    public void mangeUnAliment(boolean b) {
        for (int i = 0; i < this.kiMangeKoi.size(); ++i) {
            Boule temp;
            int j;
            int k;
            Vector listeTemp = (Vector)this.kiMangeKoi.elementAt(i);
            if (listeTemp.size() > 1) {
                for (k = 0; k < 6; ++k) {
                    for (j = 0; j < 11; ++j) {
                        if (!this.presenceBoule(k, j) || !(temp = this.getBoule(k, j)).equals(listeTemp.elementAt(1))) continue;
                        temp.setType("Mange");
                        if (!b) continue;
                        try {
                            new Thread(){

                                public void run() {
                                    String cheminSon = ".//BakuPackage//element//sound//mange.wav";
                                    try {
                                        File f = new File(cheminSon);
                                        URL url = f.toURL();
                                        AudioClip son1 = Applet.newAudioClip(url);
                                        son1.play();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }.start();
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                ((Boule)listeTemp.elementAt(0)).setPosition(((Boule)listeTemp.elementAt(1)).getX(), ((Boule)listeTemp.elementAt(1)).getY());
                listeTemp.removeElementAt(1);
                continue;
            }
            for (k = 0; k < 6; ++k) {
                for (j = 0; j < 11; ++j) {
                    if (!this.presenceBoule(k, j) || !(temp = this.getBoule(k, j)).equals(this.animauxKiMangent.elementAt(i))) continue;
                    temp.setType("Mange");
                    ((Boule)this.animauxKiMangent.elementAt(i)).setType("Mange");
                }
            }
            listeTemp.removeElementAt(0);
            this.kiMangeKoi.removeElementAt(i);
            this.animauxKiMangent.removeElementAt(i);
        }
    }

    public int mangeBoules() {
        Vector deja_passe = new Vector();
        Vector vectAliments = new Vector();
        int cpt = 0;
        int nombreAliments = 0;
        int nombreAnimaux = 0;
        this.kiMangeKoi.clear();
        this.scoreSurMangeage = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 11; ++j) {
                if (!this.presenceBoule(i, j) || deja_passe.contains(this.tableauBoules[i][j])) continue;
                nombreAliments = 0;
                nombreAnimaux = 0;
                if (!this.tableauBoules[i][j].isAnimal()) continue;
                vectAliments.clear();
                vectAliments = this.tableauBoules[i][j].getAdjacentes(vectAliments);
                deja_passe.addAll(vectAliments);
                for (int k = vectAliments.size() - 1; k >= 0; --k) {
                    if (((Boule)vectAliments.elementAt(k)).isAliment()) {
                        ++nombreAliments;
                        continue;
                    }
                    ++nombreAnimaux;
                }
                if (nombreAnimaux > 1 && nombreAliments > 0) {
                    for (int l = 0; l < nombreAnimaux - 1; ++l) {
                        Vector<Boule> listeTemp = new Vector<Boule>();
                        Boolean peutCompleter = false;
                        Boolean changeListe = false;
                        for (int m = vectAliments.size() - 1; m >= 0; --m) {
                            Boule tmp;
                            if (changeListe.booleanValue()) continue;
                            if (((Boule)vectAliments.elementAt(m)).isAliment() && peutCompleter.booleanValue()) {
                                tmp = (Boule)vectAliments.elementAt(m);
                                listeTemp.addElement(tmp);
                                if (vectAliments.size() == 2) continue;
                                vectAliments.removeElementAt(m);
                                continue;
                            }
                            if (((Boule)vectAliments.elementAt(m)).isAnimal() && peutCompleter.booleanValue()) {
                                this.kiMangeKoi.addElement(listeTemp);
                                changeListe = true;
                                continue;
                            }
                            if (!((Boule)vectAliments.elementAt(m)).isAnimal() || peutCompleter.booleanValue()) continue;
                            tmp = (Boule)vectAliments.elementAt(m);
                            listeTemp.addElement(tmp);
                            vectAliments.removeElementAt(m);
                            peutCompleter = true;
                        }
                    }
                }
                if (nombreAliments > 0) {
                    int k;
                    int emplacement = this.kiMangeKoi.size();
                    this.kiMangeKoi.add(emplacement, new Vector());
                    for (k = 0; k < vectAliments.size(); ++k) {
                        Boule tmp = (Boule)vectAliments.elementAt(k);
                        ((Vector)this.kiMangeKoi.elementAt(emplacement)).addElement(tmp);
                    }
                    for (k = 0; k < this.kiMangeKoi.size(); ++k) {
                        while (((Vector)this.kiMangeKoi.elementAt(k)).size() == 1) {
                            int z = 1;
                            while (z + k < this.kiMangeKoi.size()) {
                                if (k != this.kiMangeKoi.size() - 1 && ((Vector)this.kiMangeKoi.elementAt(k + z)).size() > 1) {
                                    ((Vector)this.kiMangeKoi.elementAt(k)).addElement(((Vector)this.kiMangeKoi.elementAt(k + z)).elementAt(1));
                                    if (((Vector)this.kiMangeKoi.elementAt(k + z)).size() > 2) {
                                        ((Vector)this.kiMangeKoi.elementAt(k + z)).removeElementAt(1);
                                    }
                                }
                                ++z;
                            }
                            z = 1;
                            while (k - z > 0) {
                                if (k != 0 && ((Vector)this.kiMangeKoi.elementAt(k - z)).size() > 1) {
                                    ((Vector)this.kiMangeKoi.elementAt(k)).addElement(((Vector)this.kiMangeKoi.elementAt(k - z)).elementAt(1));
                                    if (((Vector)this.kiMangeKoi.elementAt(k - z)).size() > 2) {
                                        ((Vector)this.kiMangeKoi.elementAt(k - z)).removeElementAt(1);
                                    }
                                }
                                ++z;
                            }
                        }
                    }
                }
                cpt += nombreAliments;
                this.scoreSurMangeage += this.calculeScore(nombreAliments, nombreAnimaux);
            }
        }
        if (!this.kiMangeKoi.isEmpty()) {
            for (int n = 0; n < this.kiMangeKoi.size(); ++n) {
                this.animauxKiMangent.addElement(((Vector)this.kiMangeKoi.elementAt(n)).elementAt(0));
            }
        }
        return cpt;
    }

    public void purgeAlimentsManges() {
        Boule temp;
        int j;
        int i;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 11; ++j) {
                if (!this.presenceBoule(i, j)) continue;
                temp = this.getBoule(i, j);
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 11; ++j) {
                if (!this.presenceBoule(i, j) || !(temp = this.getBoule(i, j)).getType().equals("Mange")) continue;
                temp.setPosition(temp.getX() + this.ABS0, temp.getY() + this.ORD0);
                this.tableauBoules[i][j] = null;
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 11; ++j) {
                if (!this.presenceBoule(i, j)) continue;
                Boule boule = this.getBoule(i, j);
            }
        }
    }

    public void retireBoule(Boule boule) {
        this.tableauBoules[boule.getColonne()][boule.getLigne()] = null;
    }

    public int getScoreSurMangeage() {
        return this.scoreSurMangeage;
    }

    public int calculeScore(int nbAliments, int nbAnimaux) {
        int total = 0;
        for (int i = 1; i < nbAliments + 1; ++i) {
            total += i;
        }
        return total += nbAnimaux - 1;
    }

    public void chercheString(String s, Vector vec) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 11; ++j) {
                Boule temp;
                if (!this.presenceBoule(i, j) || !(temp = this.getBoule(i, j)).getType().equals(s)) continue;
                vec.addElement(temp);
            }
        }
    }

    public int getClignotementBoules() {
        return this.clignotementBoules;
    }

    public void setClignotementBoules(int i) {
        this.clignotementBoules = i;
    }

    public int calculeBoulesASupprimer(Boule b1, Boule b2) {
        String aTrouver;
        this.boulesAVirer.clear();
        b1.setPosition(b1.getX() + this.ABS0, b1.getY() + this.ORD0);
        b2.setPosition(b2.getX() + this.ABS0, b2.getY() + this.ORD0);
        int i1 = b1.getColonne();
        int i2 = b2.getColonne();
        int j1 = b1.getLigne();
        int j2 = b2.getLigne();
        b1.setPosition(b1.getX() - this.ABS0, b1.getY() - this.ORD0);
        b2.setPosition(b2.getX() - this.ABS0, b2.getY() - this.ORD0);
        if (j1 != 0 && !(aTrouver = this.getBoule(i1, j1 - 1).getType()).equals("Special")) {
            this.chercheString(aTrouver, this.boulesAVirer);
        }
        if (j2 != 0 && !(aTrouver = this.getBoule(i2, j2 - 1).getType()).equals("Special")) {
            this.chercheString(aTrouver, this.boulesAVirer);
        }
        return this.boulesAVirer.size();
    }

    public void vireBoulesSpecial() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 11; ++j) {
                Boule temp;
                if (!this.presenceBoule(i, j) || !(temp = this.getBoule(i, j)).getType().equals("Special") && !this.boulesAVirer.contains(temp)) continue;
                this.tableauBoules[i][j] = null;
            }
        }
        this.boulesAVirer.clear();
    }

    public Vector<Boule> getBoulesAdjacentesStrictes(int x, int y) {
        Boule temp;
        Vector<Boule> result = new Vector<Boule>();
        for (int i = x - 1; i <= x + 1; i += 2) {
            temp = this.getBoule(i, y);
            if (null == temp) continue;
            result.add(temp);
        }
        for (int j = y - 1; j <= y + 1; j += 2) {
            temp = this.getBoule(x, j);
            if (null == temp) continue;
            result.add(temp);
        }
        return result;
    }

    public boolean isOppositeTypeOfBouleInVector(Boule b, Vector<Boule> v) {
        boolean result = false;
        if (!v.isEmpty()) {
            for (int i = 0; i < v.size(); ++i) {
                Boule temp = v.get(i);
                if (!(b.isAnimal() && temp.isAliment() ? temp.getTypeEstMangePar() == b.getType().charAt(0) : b.isAliment() && temp.isAnimal() && b.getTypeEstMangePar() == temp.getType().charAt(0))) continue;
                return true;
            }
        }
        return result;
    }

    public void debugTableau() {
        for (int j = 10; j > -1; --j) {
            for (int i = 0; i < 6; ++i) {
                if (null != this.tableauBoules[i][j]) {
                    System.out.print(this.tableauBoules[i][j].getType() + " ");
                    continue;
                }
                System.out.print("* ");
            }
            System.out.println();
        }
    }

    public boolean isVide() {
        boolean result = false;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 11; ++j) {
                if (!this.presenceBoule(i, j)) continue;
                result = true;
                break;
            }
            if (result) break;
        }
        return !result;
    }
}

